﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Domaine
{
    /// <summary>
    /// Modélise un livre de la bibliothèque
    /// </summary>
    public class Livre
    {
        private string isbn;
        private string titre;
        private string auteur;

        /// <summary>
        /// Constructeur
        /// </summary>
        /// <param name="isbn"></param>
        /// <param name="titre"></param>
        /// <param name="auteur"></param>
        public Livre(string isbn, string titre, string auteur)
        {
            this.isbn = isbn;
            this.titre = titre;
            this.auteur = auteur;
        }

        /// <summary>
        /// Numéro de série du livre (sur 14 caractères en tout)
        /// Voir http://fr.wikipedia.org/wiki/International_Standard_Book_Number
        /// </summary>
        public string Isbn
        {
            get { return isbn; }
            set { isbn = value; }
        }

        /// <summary>
        /// Titre du livre
        /// </summary>
        public string Titre
        {
            get { return titre; }
            set { titre = value; }
        }

        /// <summary>
        /// Nom de l'auteur du livre
        /// </summary>
        public string Auteur
        {
            get { return auteur; }
            set { auteur = value; }
        }

        /// <summary>
        /// Décrit un livre
        /// </summary>
        /// <returns></returns>
        public override string ToString()
        {
            return Titre;
        }
    }
}
